---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-BlazorHosted（ASP.NET Core統合）.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/wwwroot/index.html`
- E-02: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Program.cs`
- E-03: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/Pages/Chat.razor`
- E-04: `src/mono/wasm/testassets/WasmOnAspNetCore/BlazorClient/BlazorClient.csproj`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | base hrefが"/blazorclient/"に設定されている | E-01 (9行目) | ○ |
| C-02 | div#appに"Loading..."が表示される | E-01 (14行目) | ○ |
| C-03 | blazor-error-uiでエラー表示される | E-01 (16-19行目) | ○ |
| C-04 | blazor.webassembly.jsが読み込まれる | E-01 (21行目) | ○ |
| C-05 | WebAssemblyHostBuilder.CreateDefault()でビルダーを作成 | E-02 (8行目) | ○ |
| C-06 | Appコンポーネントを#appにマウント | E-02 (9行目) | ○ |
| C-07 | HttpClientをスコープサービスとして登録 | E-02 (11行目) | ○ |
| C-08 | RunAsync().ConfigureAwait(false)で起動 | E-02 (13行目) | ○ |
| C-09 | Chat.razorが@page "/"でルートにマッピング | E-03 (1行目) | ○ |
| C-10 | NavigationManagerを注入 | E-03 (2行目) | ○ |
| C-11 | h1で"Chat Room"を表示 | E-03 (4行目) | ○ |
| C-12 | ShouldRender()でデバッグログを出力 | E-03 (10-15行目) | ○ |
| C-13 | OnAfterRenderAsync()でSignalRTestを実行 | E-03 (17-32行目) | ○ |
| C-14 | WasmEnableThreadsがtrueに設定されている | E-04 (7行目) | ○ |
| C-15 | StaticWebAssetBasePathがblazorclientに設定されている | E-04 (11行目) | ○ |
| C-16 | 関連機能が画面機能マッピングに記載されている | E-06 (画面No 17の行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [x] HTML構造がindex.htmlと一致している
- [x] Program.csの起動フローが正しい
- [x] Chat.razorのライフサイクルメソッドが正しい
- [x] プロジェクト設定がBlazorClient.csprojと一致している
- [x] 関連機能が画面機能マッピング.csvと一致している
